/**
 * Fecha de creacin: (05/07/2010)
 */   
package com.ejie.p06b.datatype.logic.pagination;

import java.io.Serializable;
import java.sql.ResultSet;

import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;


public class P06BDECPagination implements P06BIPagination, Serializable {
	
	private String ejercicio = "";
	private String expediente = "";
	private String identificador = "";
	private String corredor = "";
	
	public P06BDECPagination(){
	}
	
	public P06BDECPagination(String ejercicio, String expediente, String identificador, String corredor){
		this.ejercicio = ejercicio;
		this.expediente = expediente;
		this.identificador = identificador;
		this.corredor = corredor;
	}
	
	public Object getObj() throws Exception {
		return new P06BDECPagination(this.ejercicio, this.expediente, this.identificador, this.corredor);
	}
	/* (non-Javadoc)
	 * @see com.ejie.p06b.datatype.logic.pagination.P06BIPagination#setRS(java.sql.ResultSet)
	 */
	public void setRS(ResultSet rs) throws Exception {
		String ejer = (rs.getString(P06BTablas.P06B_P06B32_EJERCICIO)==null)?"":rs.getString(P06BTablas.P06B_P06B32_EJERCICIO);
		String exp = (rs.getString(P06BTablas.P06B_P06B32_NUMEXP)==null)?"":rs.getString(P06BTablas.P06B_P06B32_NUMEXP);
		String iden = (rs.getString(P06BTablas.P06B_P06B32_IDENTIFICADOR)==null)?"":rs.getString(P06BTablas.P06B_P06B32_IDENTIFICADOR);
		String tipocorred = (rs.getString(P06BTablas.P06B_P06B32_CLASE)==null)?"":rs.getString(P06BTablas.P06B_P06B32_CLASE);
		String corred="";
		if( (tipocorred.equals(P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA))
			|| (tipocorred.equals(P06BConstantes.P06B_AGENTEVINCULADO_FISICA)) 
			|| (tipocorred.equals(P06BConstantes.P06B_REASEGUROS_FISICA))){
			corred = (rs.getString(P06BTablas.P06B_P06B32_NOMBRE)==null)?"":rs.getString(P06BTablas.P06B_P06B32_NOMBRE);
			corred += " " + ((rs.getString(P06BTablas.P06B_P06B32_APE1)==null)?"":rs.getString(P06BTablas.P06B_P06B32_APE1));
			corred += " " + ((rs.getString(P06BTablas.P06B_P06B32_APE2)==null)?"":rs.getString(P06BTablas.P06B_P06B32_APE2));
		}else{
			corred = (rs.getString(P06BTablas.P06B_P06B32_RAZSOC)==null)?"":rs.getString(P06BTablas.P06B_P06B32_RAZSOC);
		}
		//Acoto la longitud del campo corredor para el listado
		if(corred.length()>=38){
			corred = corred.substring(0,37);
			corred += "...";
		}
		
		this.setEjercicio(ejer);
		this.setExpediente(exp);
		this.setIdentificador(iden);
		this.setCorredor(corred);
	}
	/**
	 * @return Returns the corredor.
	 */
	public String getCorredor() {
		return corredor;
	}
	/**
	 * @param corredor The corredor to set.
	 */
	public void setCorredor(String corredor) {
		this.corredor = corredor;
	}
	/**
	 * @return Returns the expediente.
	 */
	public String getExpediente() {
		return expediente;
	}
	/**
	 * @param expediente The expediente to set.
	 */
	public void setExpediente(String expediente) {
		this.expediente = expediente;
	}
	/**
	 * @return Returns the identificador.
	 */
	public String getIdentificador() {
		return identificador;
	}
	/**
	 * @param identificador The identificador to set.
	 */
	public void setIdentificador(String identificador) {
		this.identificador = identificador;
	}
	
	/**
	 * @return Returns the ejercicio.
	 */
	public String getEjercicio() {
		return ejercicio;
	}
	/**
	 * @param ejercicio The ejercicio to set.
	 */
	public void setEjercicio(String ejercicio) {
		this.ejercicio = ejercicio;
	}
	
	
	
}
